<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kredensial Portal Pasien - Klinik Kecantikan</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
            border-radius: 10px 10px 0 0;
        }
        .content {
            background: #f8f9fa;
            padding: 30px;
            border-radius: 0 0 10px 10px;
        }
        .credentials-box {
            background: #e8f5e8;
            border: 2px solid #4caf50;
            border-radius: 8px;
            padding: 20px;
            margin: 20px 0;
            text-align: center;
        }
        .credentials-box h3 {
            color: #2e7d32;
            margin-bottom: 15px;
        }
        .credential-item {
            background: white;
            border: 1px solid #4caf50;
            border-radius: 5px;
            padding: 15px;
            margin: 10px 0;
            font-family: monospace;
            font-size: 16px;
            font-weight: bold;
        }
        .button {
            display: inline-block;
            background: #4caf50;
            color: white;
            padding: 12px 24px;
            text-decoration: none;
            border-radius: 5px;
            margin: 10px 0;
        }
        .warning-box {
            background: #fff3cd;
            border: 1px solid #ffeaa7;
            border-radius: 8px;
            padding: 15px;
            margin: 20px 0;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>🏥 Klinik Kecantikan</h1>
        <h2>Kredensial Portal Pasien</h2>
    </div>

    <div class="content">
        <p>Halo <strong>{{ $patient->name }}</strong>,</p>
        
        <p>Kredensial untuk akses Portal Pasien Anda telah dibuat. Gunakan informasi di bawah ini untuk mengakses hasil pemeriksaan Anda.</p>

        <div class="credentials-box">
            <h3>🔐 Kredensial Login Portal Pasien</h3>
            
            <div class="credential-item">
                <strong>No. Rekam Medis (MRN):</strong><br>
                <span style="color: #2e7d32; font-size: 18px;">{{ $patient->mrn }}</span>
            </div>
            
            <div class="credential-item">
                <strong>Password:</strong><br>
                <span style="color: #2e7d32; font-size: 18px;">{{ $password }}</span>
            </div>
        </div>

        <div class="warning-box">
            <h4>⚠️ Penting - Simpan Informasi Ini!</h4>
            <ul style="margin: 10px 0; padding-left: 20px;">
                <li>Simpan MRN dan password dengan aman</li>
                <li>Jangan bagikan kredensial ini dengan orang lain</li>
                <li>Gunakan kredensial ini untuk mengakses Portal Pasien</li>
                <li>Jika lupa password, hubungi admin untuk reset</li>
            </ul>
        </div>

        <div style="text-align: center; margin: 30px 0;">
            <a href="{{ route('results.patient.form') }}" class="button">
                🏥 Akses Portal Pasien
            </a>
        </div>

        <div style="background: #e3f2fd; border: 1px solid #2196f3; border-radius: 8px; padding: 15px; margin: 20px 0;">
            <h3>📋 Cara Menggunakan Portal Pasien:</h3>
            <ol style="margin: 10px 0; padding-left: 20px;">
                <li>Klik tombol "Akses Portal Pasien" di atas</li>
                <li>Masukkan MRN dan password yang diberikan</li>
                <li>Lihat hasil pemeriksaan Anda</li>
                <li>Download file hasil jika tersedia</li>
            </ol>
        </div>

        <p>Jika Anda memiliki pertanyaan atau mengalami masalah, silakan hubungi kami di:</p>
        <ul>
            <li>📞 Telepon: (021) 1234-5678</li>
            <li>📧 Email: info@klinikkecantikan.com</li>
            <li>🌐 Website: www.klinikkecantikan.com</li>
        </ul>
    </div>

    <div class="footer">
        <p>© {{ date('Y') }} Klinik Kecantikan. Semua hak dilindungi.</p>
        <p>Email ini dikirim secara otomatis, harap tidak membalas email ini.</p>
    </div>
</body>
</html>
